/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class SelectDefaultEditorPanel
extends DataInputPanel {
    protected JLabel fDefaultEditorLabel;
    protected JComboBox fDefaultEditorComboBox;
    protected Application fApplication = Application.getInstance();

    public SelectDefaultEditorPanel() {
        this.initComponents();
    }

    public boolean checkChanged() {
        String currentEditorClassName = this.fApplication.getDefaultEditor().getEditorInfo().getEditorClassName();
        String selectedEditorClassName = ((EditorInfo)this.fDefaultEditorComboBox.getSelectedItem()).getEditorClassName();
        return !selectedEditorClassName.equals(currentEditorClassName);
    }

    public String getTitle() {
        return Language.getString("dialog.selectEditor.editor", "Editor");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fDefaultEditorLabel = new JLabel("StandardEditor");
        this.fDefaultEditorComboBox = new JComboBox();
        GridBagConstraints gbc = null;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.fDefaultEditorLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.fDefaultEditorComboBox, gbc);
        this.fDefaultEditorComboBox.setRenderer(new EditorInfoListCellRenderer());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public void loadFieldContents() {
        Vector editorInfos = this.fApplication.getEditorInfos();
        DefaultComboBoxModel dcbm = new DefaultComboBoxModel(editorInfos);
        this.fDefaultEditorComboBox.setModel(dcbm);
        EditorInfo currentDefaultEditor = this.fApplication.getDefaultEditor().getEditorInfo();
        Enumeration e = editorInfos.elements();
        EditorInfo editorInfo = null;
        while (e.hasMoreElements()) {
            editorInfo = (EditorInfo)e.nextElement();
            if (!editorInfo.getEditorClassName().equals(currentDefaultEditor.getEditorClassName())) continue;
            this.fDefaultEditorComboBox.setSelectedItem(editorInfo);
            break;
        }
    }

    public void setLabels() {
        this.fDefaultEditorLabel.setText(Language.getString("dialog.selectEditor.editor", "Default editor"));
    }

    public void storeFieldContents() {
        this.fApplication.setDefaultEditor((EditorInfo)this.fDefaultEditorComboBox.getSelectedItem());
    }

    private class EditorInfoListCellRenderer
    extends DefaultListCellRenderer {
        private EditorInfoListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof EditorInfo) {
                EditorInfo editorInfo = (EditorInfo)value;
                this.setText(editorInfo.getName());
                this.setIcon(editorInfo.getIcon());
            }
            return this;
        }
    }
}

